/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp;

import com.ibm.hsc.common.util.HSCVPD;
import com.ibm.hsc.common.util.HardwareServerMessage;
import com.ibm.hsc.common.util.HexDump;
import com.ibm.hsc.fsp.FSPCMIdGenerator;
import com.ibm.hsc.fsp.FspConnListener;
import com.ibm.hsc.fsp.FspInDataHandler;
import com.ibm.hsc.fsp.cmdhelpers.FspHardwareServerInfo;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class HWSvrSocket
extends Thread {
    private static HWSvrSocket mInst = null;
    private DataInputStream mInStream;
    private Socket mSocket;
    private Hashtable mInDataHandlers = new Hashtable();
    private FspConnListener mConnListener;
    private boolean mInRestart = false;
    private String mHostName = null;
    private String mHmcId = null;

    public static synchronized HWSvrSocket getInstance() {
        return mInst;
    }

    public static synchronized HWSvrSocket createInstance(FspConnListener fspConnListener) {
        if (mInst == null) {
            System.out.println("HWSocket inst is null");
            try {
                mInst = new HWSvrSocket("localhost", fspConnListener);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        } else {
            System.out.println("HWSocket inst is not null");
        }
        return mInst;
    }

    private HWSvrSocket(String string, FspConnListener fspConnListener) {
        this.mHostName = string;
        this.mConnListener = fspConnListener;
        this.getHmcId();
    }

    public void initialize() {
        this.createSocket();
        this.start();
    }

    public void addVport(int n, FspInDataHandler fspInDataHandler) {
        System.out.println("add vport " + n + " inDataHandler " + fspInDataHandler);
        Integer n2 = new Integer(n);
        this.mInDataHandlers.put(n2, fspInDataHandler);
    }

    public FspInDataHandler getInDataHandler(int n) {
        Integer n2 = new Integer(n);
        return (FspInDataHandler)this.mInDataHandlers.get(n2);
    }

    private String getLocalHmcId() {
        if (this.mHmcId == null) {
            try {
                HSCVPD hSCVPD = new HSCVPD();
                String string = null;
                String string2 = null;
                if (hSCVPD.isVPDPresent()) {
                    string = hSCVPD.getHSCModel();
                    string2 = hSCVPD.getHSCSerialNumber();
                    this.mHmcId = string.concat("*").concat(string2);
                    System.out.println("HmcId: " + this.mHmcId);
                } else {
                    System.out.println("Cannot get hmc id. vpd: " + hSCVPD);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return this.mHmcId;
    }

    public synchronized String getHmcId() {
        int n = 5000;
        if (this.mHmcId != null) {
            return this.mHmcId;
        }
        boolean bl = false;
        while (!bl) {
            Object var3_3 = null;
            try {
                System.out.println("bef create HWS socket for getting hmcid");
                if (this.mSocket == null) {
                    this.mSocket = new Socket(this.mHostName, 8877);
                }
                System.out.println("created HWS socket for getting hmcid");
                byte[] byArray = new byte[]{-85, -85, -85, -85, 16, 29, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -3};
                this.setCorrelator(byArray);
                Vector vector = new Vector();
                this.doHWCmd(byArray, vector);
                if (vector.size() > 0) {
                    HardwareServerMessage hardwareServerMessage = (HardwareServerMessage)vector.elementAt(0);
                    int n2 = hardwareServerMessage.getMinorOpCode();
                    int n3 = hardwareServerMessage.getMajorOpCode();
                    System.out.println("major = " + n3 + " minor = " + n2);
                    if (n3 == 16 && n2 == 30) {
                        FspHardwareServerInfo fspHardwareServerInfo = new FspHardwareServerInfo(hardwareServerMessage);
                        this.mHmcId = fspHardwareServerInfo.getHmcMtms();
                    }
                }
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    if (this.mSocket != null) {
                        this.mSocket.close();
                    }
                    Thread.currentThread();
                    Thread.sleep(n);
                    if (n < 600000) {
                        n *= 2;
                    }
                }
                catch (Throwable throwable2) {
                    throwable2.printStackTrace();
                }
                this.mSocket = null;
            }
        }
        System.out.println("the hmc id from hardware server: " + this.mHmcId);
        System.out.println("the local hmc id is: " + this.getLocalHmcId());
        if (this.mHmcId == null) {
            this.mHmcId = this.getLocalHmcId();
        }
        return this.mHmcId;
    }

    public FspInDataHandler removeVport(int n) {
        System.out.println("remove vport: " + n);
        Integer n2 = new Integer(n);
        return (FspInDataHandler)this.mInDataHandlers.remove(n2);
    }

    private void processResponse(HardwareServerMessage hardwareServerMessage) {
        try {
            System.out.println("Entering processResponse...");
            int n = hardwareServerMessage.getMinorOpCode();
            int n2 = hardwareServerMessage.getMajorOpCode();
            Integer n3 = new Integer(hardwareServerMessage.getVirtualPort());
            System.out.println("minor3= " + n + " major3= " + n2 + " vport= " + n3);
            FspInDataHandler fspInDataHandler = (FspInDataHandler)this.mInDataHandlers.get(n3);
            if (fspInDataHandler == null) {
                System.out.println("inDataHandler is null");
            }
            if (n2 == 160 && n == 119 || n2 == 160 && n == 123 || n2 == 160 && n == 137) {
                System.out.println("##### found new vport");
                this.mConnListener.foundNewVport(hardwareServerMessage);
            } else if (n2 == 80 && (n == 97 || n == 98 || n == 100 || n == 101 || n == 106 || n == 107 || n == 109 || n == 110 || n == 113 || n == 114 || n == 116 || n == 117 || n == 119 || n == 120 || n == 125 || n == 126 || n == 128 || n == 129) || n2 == 160 && (n == 131 || n == 132) || n2 == 32 && (n == 59 || n == 60 || n == 74 || n == 75)) {
                if (fspInDataHandler != null) {
                    fspInDataHandler.handleInData(hardwareServerMessage);
                } else {
                    System.out.println("vport.intValue: " + n3);
                    System.out.println("vport: " + n3 + " is not in the managed table");
                    System.out.println("mInDataHandlers: " + this.mInDataHandlers);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCommand(byte[] byArray) throws IOException {
        if (this.mInRestart) {
            throw new RuntimeException("reconnecting to hardware server");
        }
        Socket socket = this.mSocket;
        synchronized (socket) {
            try {
                this.mSocket.getOutputStream().write(byArray);
                this.mSocket.getOutputStream().flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                if (!(iOException instanceof InterruptedIOException)) {
                    this.restart();
                }
                throw iOException;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.restart();
                throw new IOException("sending down fsp command failed with exception " + throwable.getMessage());
            }
        }
    }

    private void createSocket() {
        boolean bl = false;
        int n = 5000;
        while (!bl) {
            block9: {
                try {
                    System.out.println("bef created HW server socket");
                    if (this.mSocket != null) break block9;
                    this.mSocket = new Socket(this.mHostName, 8877);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    try {
                        Thread.currentThread();
                        Thread.sleep(n);
                        if (n >= 600000) continue;
                        n *= 2;
                    }
                    catch (Throwable throwable2) {
                        throwable2.printStackTrace();
                    }
                    continue;
                }
            }
            try {
                System.out.println("after created HW server socket");
                this.getHmcId();
                System.out.println("after get the hmc id");
                this.regNewCecListener();
                this.queryFspData();
                System.out.println("after init the socket");
                this.mConnListener.hardwareServerConnected();
                bl = true;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                try {
                    this.mSocket.close();
                    Thread.currentThread();
                    Thread.sleep(5000L);
                }
                catch (Throwable throwable3) {
                    throwable3.printStackTrace();
                }
                this.mSocket = null;
            }
        }
    }

    private void queryFspData() {
        int n;
        Object object;
        int n2;
        byte[] byArray = new byte[]{-85, -85, -85, -85, 16, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -2};
        byte[] byArray2 = new byte[]{32, 53};
        byte[] byArray3 = new byte[]{33, 54};
        byte[] byArray4 = new byte[]{34, 55};
        byte[] byArray5 = new byte[]{35, 56};
        byte[] byArray6 = new byte[]{36, 57};
        byte[] byArray7 = new byte[]{37, 58};
        Vector vector = new Vector();
        for (n2 = 0; n2 < 2; ++n2) {
            int n3;
            byArray[5] = byArray2[n2];
            this.setCorrelator(byArray);
            object = new Vector();
            this.setCorrelator(byArray);
            this.doHWCmd(byArray, (Vector)object);
            byte[] byArray8 = null;
            n = -1;
            System.out.println("listResp.size():" + ((Vector)object).size());
            for (n3 = 0; n3 < ((Vector)object).size(); ++n3) {
                HardwareServerMessage hardwareServerMessage = (HardwareServerMessage)((Vector)object).elementAt(n3);
                int n4 = hardwareServerMessage.getMinorOpCode();
                int n5 = hardwareServerMessage.getMajorOpCode();
                System.out.println("major = " + n5 + " minor = " + n4);
                if (n5 == 16 && n4 == byArray3[n2]) {
                    byArray8 = hardwareServerMessage.getPayload();
                    System.out.println("vportPayload.length: " + byArray8.length);
                    break;
                }
                if (n5 == 16 && n4 == byArray4[n2]) break;
            }
            if (byArray8 != null && byArray8.length > 3) {
                byArray[5] = byArray5[n2];
                n3 = byArray8.length >> 2;
                for (int i = 0; i < n3; ++i) {
                    byArray[8] = byArray8[i * 4];
                    byArray[9] = byArray8[i * 4 + 1];
                    byArray[10] = byArray8[i * 4 + 2];
                    byArray[11] = byArray8[i * 4 + 3];
                    this.setCorrelator(byArray);
                    this.doHWCmd(byArray, vector);
                }
            }
            System.out.println("resp.size1():" + vector.size());
        }
        this.mInRestart = false;
        for (n2 = 0; n2 < vector.size(); ++n2) {
            object = (HardwareServerMessage)vector.elementAt(n2);
            int n6 = ((HardwareServerMessage)object).getMinorOpCode();
            n = ((HardwareServerMessage)object).getMajorOpCode();
            System.out.println("major1 = " + n + " minor1 = " + n6);
            if (n == 16 && (n6 == 36 || n6 == 57)) {
                System.out.println("call mConnListener.foundNewVport");
                this.mConnListener.foundNewVport((HardwareServerMessage)object);
                continue;
            }
            if (n == 16 && (n6 == 37 || n6 == 58)) continue;
            this.processResponse((HardwareServerMessage)object);
        }
    }

    private void doHWCmd(byte[] byArray, Vector vector) {
        System.out.println("HS cmd: " + new HexDump(byArray).toString());
        try {
            int n;
            int n2;
            System.out.println("send out HS cmd");
            this.mSocket.getOutputStream().write(byArray);
            this.mSocket.getOutputStream().flush();
            System.out.println("try to get the resp for async reg");
            do {
                HardwareServerMessage hardwareServerMessage = new HardwareServerMessage(this.mSocket.getInputStream());
                System.out.println("got the resp: " + hardwareServerMessage.toString());
                if (vector == null) {
                    return;
                }
                vector.addElement(hardwareServerMessage);
                n = hardwareServerMessage.getMinorOpCode();
                n2 = hardwareServerMessage.getMajorOpCode();
                System.out.println("major2 = " + n2 + " minor2 = " + n);
            } while ((n2 != 16 || n != 36 && n != 37) && (n2 != 16 || n != 33 && n != 34) && (n2 != 16 || n != 57 && n != 58) && (n2 != 16 || n != 54 && n != 55) && (n2 != 16 || n != 30 && n != 31));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void regNewCecListener() {
        byte[] byArray = new byte[]{-85, -85, -85, -85, 32, 70, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1};
        System.out.println("start HANDLING CONN REG");
        this.setCorrelator(byArray);
        this.doHWCmd(byArray, null);
    }

    public void setCorrelator(byte[] byArray) {
        if (byArray == null || byArray.length < 30) {
            return;
        }
        int n = FSPCMIdGenerator.getInstance().genReqId();
        HardwareServerMessage.intToBytes(n, byArray, 26);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restart() {
        System.out.println("restart the HW socket");
        if (this.mInRestart) {
            HWSvrSocket hWSvrSocket = this;
            synchronized (hWSvrSocket) {
                return;
            }
        }
        HWSvrSocket hWSvrSocket = this;
        synchronized (hWSvrSocket) {
            this.mInRestart = true;
            try {
                try {
                    if (this.mSocket != null) {
                        this.mSocket.close();
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                this.mSocket = null;
                Enumeration enumeration = this.mInDataHandlers.elements();
                while (enumeration != null && enumeration.hasMoreElements()) {
                    FspInDataHandler fspInDataHandler = (FspInDataHandler)enumeration.nextElement();
                    try {
                        fspInDataHandler.disconnect(true, System.currentTimeMillis());
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                this.createSocket();
            }
            finally {
                this.mInRestart = false;
            }
        }
    }

    public void run() {
        System.out.println("starts the listener thread");
        InputStream inputStream = null;
        while (true) {
            if (this.mInRestart) {
                try {
                    Thread.currentThread();
                    Thread.sleep(5000L);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                continue;
            }
            try {
                inputStream = this.mSocket.getInputStream();
                System.out.println("got the socket input stream: " + inputStream);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.restart();
                continue;
            }
            try {
                while (true) {
                    System.out.println("before listenning to HW socket");
                    HardwareServerMessage hardwareServerMessage = new HardwareServerMessage(inputStream);
                    System.out.println("hdwr_svr response = " + hardwareServerMessage.toString());
                    this.processResponse(hardwareServerMessage);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.mConnListener.hardwareServerDisconnected();
                this.restart();
                continue;
            }
            break;
        }
    }
}

